/*
 * Decompiled with CFR 0.152.
 */
package committee.nova.mods.avaritia.util.vec;

import committee.nova.mods.avaritia.util.java.Copyable;
import committee.nova.mods.avaritia.util.java.StreamableIterable;
import committee.nova.mods.avaritia.util.vec.Matrix4;
import committee.nova.mods.avaritia.util.vec.Transformation;
import committee.nova.mods.avaritia.util.vec.Vector3;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class TransformationList
extends Transformation {
    private ArrayList<Transformation> transformations = new ArrayList();
    @Nullable
    private Matrix4 mat;

    public TransformationList(Transformation ... transforms) {
        this(Arrays.asList(transforms));
    }

    public TransformationList(List<Transformation> transforms) {
        for (Transformation t : transforms) {
            if (t instanceof TransformationList) {
                this.transformations.addAll(((TransformationList)t).transformations);
                continue;
            }
            this.transformations.add(t);
        }
        this.compact();
    }

    public TransformationList(TransformationList other) {
        this.transformations = StreamableIterable.of(other.transformations).map(Copyable::copy).toList();
        this.mat = other.mat;
    }

    public Matrix4 compile() {
        if (this.mat == null) {
            this.mat = new Matrix4();
            for (int i = this.transformations.size() - 1; i >= 0; --i) {
                this.transformations.get(i).apply(this.mat);
            }
        }
        return this.mat;
    }

    public Matrix4 reverseCompile() {
        Matrix4 mat = new Matrix4();
        for (Transformation t : this.transformations) {
            t.apply(mat);
        }
        return mat;
    }

    @Override
    public void apply(Vector3 vec) {
        if (this.mat != null) {
            this.mat.apply(vec);
        } else {
            for (Transformation transformation : this.transformations) {
                transformation.apply(vec);
            }
        }
    }

    @Override
    public void applyN(Vector3 normal) {
        if (this.mat != null) {
            this.mat.applyN(normal);
        } else {
            for (Transformation transformation : this.transformations) {
                transformation.applyN(normal);
            }
        }
    }

    @Override
    public void apply(Matrix4 mat) {
        mat.multiply(this.compile());
    }

    @Override
    public TransformationList with(Transformation t) {
        if (t.isRedundant()) {
            return this;
        }
        this.mat = null;
        if (t instanceof TransformationList) {
            this.transformations.addAll(((TransformationList)t).transformations);
        } else {
            this.transformations.add(t);
        }
        this.compact();
        return this;
    }

    public TransformationList prepend(Transformation t) {
        if (t.isRedundant()) {
            return this;
        }
        this.mat = null;
        if (t instanceof TransformationList) {
            this.transformations.addAll(0, ((TransformationList)t).transformations);
        } else {
            this.transformations.add(0, t);
        }
        this.compact();
        return this;
    }

    private void compact() {
        ArrayList<Transformation> newList = new ArrayList<Transformation>(this.transformations.size());
        Iterator<Transformation> iterator = this.transformations.iterator();
        Transformation prev = null;
        while (iterator.hasNext()) {
            Transformation t = iterator.next();
            if (t.isRedundant()) continue;
            if (prev != null) {
                Transformation m = prev.merge(t);
                if (m == null) {
                    newList.add(prev);
                } else {
                    t = m.isRedundant() ? null : m;
                }
            }
            prev = t;
        }
        if (prev != null) {
            newList.add(prev);
        }
        if (newList.size() < this.transformations.size()) {
            this.transformations = newList;
            this.mat = null;
        }
        if (this.transformations.size() > 3 && this.mat == null) {
            this.compile();
        }
    }

    @Override
    public boolean isRedundant() {
        return this.transformations.size() == 0;
    }

    @Override
    public Transformation inverse() {
        TransformationList rev = new TransformationList(new Transformation[0]);
        for (int i = this.transformations.size() - 1; i >= 0; --i) {
            rev.with((Transformation)this.transformations.get(i).inverse());
        }
        return rev;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        for (Transformation t : this.transformations) {
            s.append("\n").append(t.toString());
        }
        return s.toString().trim();
    }

    @Override
    public TransformationList copy() {
        return new TransformationList(this);
    }
}

